/*
 * Decompiled with CFR 0.152.
 */
package io.github.vinceglb.filekit.core;

import io.github.vinceglb.filekit.core.PlatformInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Files;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000fH\u0086@\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\r\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lio/github/vinceglb/filekit/core/PlatformFile;", "", "file", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "name", "", "getName", "()Ljava/lang/String;", "path", "getPath", "readBytes", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getStream", "Lio/github/vinceglb/filekit/core/PlatformInputStream;", "getSize", "", "()Ljava/lang/Long;", "supportsStreams", "", "component1", "copy", "equals", "other", "hashCode", "", "toString", "filekit-core"})
public final class PlatformFile {
    @NotNull
    private final File file;
    @NotNull
    private final String name;
    @Nullable
    private final String path;

    public PlatformFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        String string = this.file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.name = string;
        this.path = this.file.getAbsolutePath();
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final String getPath() {
        return this.path;
    }

    @Nullable
    public final Object readBytes(@NotNull Continuation<? super byte[]> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super byte[]>, Object>(this, null){
            int label;
            final /* synthetic */ PlatformFile this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        return FilesKt.readBytes((File)this.this$0.getFile());
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super byte[]> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @NotNull
    public final PlatformInputStream getStream() {
        return new PlatformInputStream(new FileInputStream(this.file));
    }

    @Nullable
    public final Long getSize() {
        return Files.size(this.file.toPath());
    }

    public final boolean supportsStreams() {
        return true;
    }

    @NotNull
    public final File component1() {
        return this.file;
    }

    @NotNull
    public final PlatformFile copy(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new PlatformFile(file);
    }

    public static /* synthetic */ PlatformFile copy$default(PlatformFile platformFile, File file, int n, Object object) {
        if ((n & 1) != 0) {
            file = platformFile.file;
        }
        return platformFile.copy(file);
    }

    @NotNull
    public String toString() {
        return "PlatformFile(file=" + this.file + ")";
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PlatformFile)) {
            return false;
        }
        PlatformFile platformFile = (PlatformFile)other;
        return Intrinsics.areEqual((Object)this.file, (Object)platformFile.file);
    }
}

