/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.model;

import io.lindstrom.m3u8.model.StartTimeOffset;
import java.util.ArrayList;
import java.util.Objects;

class StartTimeOffsetBuilder {
    private static final long INIT_BIT_TIME_OFFSET = 1L;
    private static final long OPT_BIT_PRECISE = 1L;
    private long initBits = 1L;
    private long optBits;
    private double timeOffset;
    private boolean precise;

    StartTimeOffsetBuilder() {
        if (!(this instanceof StartTimeOffset.Builder)) {
            throw new UnsupportedOperationException("Use: new StartTimeOffset.Builder()");
        }
    }

    public final StartTimeOffset.Builder from(StartTimeOffset instance) {
        Objects.requireNonNull(instance, "instance");
        this.timeOffset(instance.timeOffset());
        this.precise(instance.precise());
        return (StartTimeOffset.Builder)this;
    }

    public final StartTimeOffset.Builder timeOffset(double timeOffset) {
        this.timeOffset = timeOffset;
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return (StartTimeOffset.Builder)this;
    }

    public final StartTimeOffset.Builder precise(boolean precise) {
        this.precise = precise;
        this.optBits |= 1L;
        return (StartTimeOffset.Builder)this;
    }

    public StartTimeOffset build() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
        return new ImmutableStartTimeOffset(this);
    }

    private boolean preciseIsSet() {
        return (this.optBits & 1L) != 0L;
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if ((this.initBits & 1L) != 0L) {
            attributes.add("timeOffset");
        }
        return "Cannot build StartTimeOffset, some of required attributes are not set " + attributes;
    }

    private static final class ImmutableStartTimeOffset
    implements StartTimeOffset {
        private final double timeOffset;
        private final boolean precise;

        private ImmutableStartTimeOffset(StartTimeOffsetBuilder builder) {
            this.timeOffset = builder.timeOffset;
            this.precise = builder.preciseIsSet() ? builder.precise : StartTimeOffset.super.precise();
        }

        @Override
        public double timeOffset() {
            return this.timeOffset;
        }

        @Override
        public boolean precise() {
            return this.precise;
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableStartTimeOffset && this.equalTo((ImmutableStartTimeOffset)another);
        }

        private boolean equalTo(ImmutableStartTimeOffset another) {
            return Double.doubleToLongBits(this.timeOffset) == Double.doubleToLongBits(another.timeOffset) && this.precise == another.precise;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Double.hashCode(this.timeOffset);
            h += (h << 5) + Boolean.hashCode(this.precise);
            return h;
        }

        public String toString() {
            return "StartTimeOffset{timeOffset=" + this.timeOffset + ", precise=" + this.precise + "}";
        }
    }
}

