/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.parser;

import io.lindstrom.m3u8.model.DateRange;
import io.lindstrom.m3u8.parser.Attribute;
import io.lindstrom.m3u8.parser.ParserUtils;
import io.lindstrom.m3u8.parser.ParsingMode;
import io.lindstrom.m3u8.parser.PlaylistParserException;
import io.lindstrom.m3u8.parser.TextBuilder;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Map;

enum DateRangeAttribute implements Attribute<DateRange, DateRange.Builder>
{
    ID{

        @Override
        public void read(DateRange.Builder builder, String value) {
            builder.id(value);
        }

        @Override
        public void write(DateRange value, TextBuilder textBuilder) {
            textBuilder.addQuoted(this.name(), value.id());
        }
    }
    ,
    CLASS{

        @Override
        public void read(DateRange.Builder builder, String value) {
            builder.classAttribute(value);
        }

        @Override
        public void write(DateRange value, TextBuilder textBuilder) {
            value.classAttribute().ifPresent(v -> textBuilder.addQuoted(this.name(), (String)v));
        }
    }
    ,
    START_DATE{

        @Override
        public void read(DateRange.Builder builder, String value) {
            builder.startDate(OffsetDateTime.parse(value, ParserUtils.FORMATTER));
        }

        @Override
        public void write(DateRange value, TextBuilder textBuilder) {
            textBuilder.addQuoted(this.key(), DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(value.startDate()));
        }
    }
    ,
    END_DATE{

        @Override
        public void read(DateRange.Builder builder, String value) {
            builder.endDate(OffsetDateTime.parse(value, ParserUtils.FORMATTER));
        }

        @Override
        public void write(DateRange value, TextBuilder textBuilder) {
            value.endDate().ifPresent(v -> textBuilder.addQuoted(this.key(), DateTimeFormatter.ISO_OFFSET_DATE_TIME.format((TemporalAccessor)v)));
        }
    }
    ,
    DURATION{

        @Override
        public void read(DateRange.Builder builder, String value) {
            builder.duration(Double.parseDouble(value));
        }

        @Override
        public void write(DateRange value, TextBuilder textBuilder) {
            value.duration().ifPresent(v -> textBuilder.add(this.name(), Double.toString(v)));
        }
    }
    ,
    PLANNED_DURATION{

        @Override
        public void read(DateRange.Builder builder, String value) {
            builder.plannedDuration(Double.parseDouble(value));
        }

        @Override
        public void write(DateRange value, TextBuilder textBuilder) {
            value.plannedDuration().ifPresent(v -> textBuilder.add(this.key(), Double.toString(v)));
        }
    }
    ,
    SCTE35_CMD{

        @Override
        public void read(DateRange.Builder builder, String value) {
            builder.scte35Cmd(value);
        }

        @Override
        public void write(DateRange value, TextBuilder textBuilder) {
            value.scte35Cmd().ifPresent(v -> textBuilder.add(this.key(), (String)v));
        }
    }
    ,
    SCTE35_OUT{

        @Override
        public void read(DateRange.Builder builder, String value) {
            builder.scte35Out(value);
        }

        @Override
        public void write(DateRange value, TextBuilder textBuilder) {
            value.scte35Out().ifPresent(v -> textBuilder.add(this.key(), (String)v));
        }
    }
    ,
    SCTE35_IN{

        @Override
        public void read(DateRange.Builder builder, String value) {
            builder.scte35In(value);
        }

        @Override
        public void write(DateRange value, TextBuilder textBuilder) {
            value.scte35In().ifPresent(v -> textBuilder.add(this.key(), (String)v));
        }
    }
    ,
    END_ON_NEXT{

        @Override
        public void read(DateRange.Builder builder, String value) throws PlaylistParserException {
            builder.endOnNext(ParserUtils.yesOrNo(value));
        }

        @Override
        public void write(DateRange value, TextBuilder textBuilder) {
            if (value.endOnNext()) {
                textBuilder.add(this.key(), "YES");
            }
        }
    }
    ,
    CLIENT_ATTRIBUTE{

        @Override
        public void read(DateRange.Builder builder, String value) {
            throw new IllegalStateException();
        }

        @Override
        public void read(DateRange.Builder builder, String key, String value) {
            builder.putClientAttributes(key, value);
        }

        @Override
        public void write(DateRange value, TextBuilder textBuilder) {
            value.clientAttributes().forEach(textBuilder::addQuoted);
        }
    };

    static final Map<String, DateRangeAttribute> attributeMap;

    static DateRange parse(String attributes, ParsingMode parsingMode) throws PlaylistParserException {
        DateRange.Builder builder = DateRange.builder();
        ParserUtils.readAttributes(attributeMap, attributes, builder, parsingMode);
        return builder.build();
    }

    static {
        attributeMap = ParserUtils.toMap(DateRangeAttribute.values(), Attribute::key);
    }
}

