/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.parser;

import io.lindstrom.m3u8.model.SegmentMap;
import io.lindstrom.m3u8.parser.Attribute;
import io.lindstrom.m3u8.parser.ParserUtils;
import io.lindstrom.m3u8.parser.ParsingMode;
import io.lindstrom.m3u8.parser.PlaylistParserException;
import io.lindstrom.m3u8.parser.TextBuilder;
import java.util.Map;

enum SegmentMapAttribute implements Attribute<SegmentMap, SegmentMap.Builder>
{
    URI{

        @Override
        public void read(SegmentMap.Builder builder, String value) {
            builder.uri(value);
        }

        @Override
        public void write(SegmentMap value, TextBuilder textBuilder) {
            textBuilder.addQuoted(this.name(), value.uri());
        }
    }
    ,
    BYTERANGE{

        @Override
        public void read(SegmentMap.Builder builder, String value) throws PlaylistParserException {
            builder.byteRange(ParserUtils.parseByteRange(value));
        }

        @Override
        public void write(SegmentMap value, TextBuilder textBuilder) {
            value.byteRange().map(ParserUtils::writeByteRange).ifPresent(v -> textBuilder.addQuoted(this.name(), (String)v));
        }
    };

    static final Map<String, SegmentMapAttribute> attributeMap;

    static SegmentMap parse(String attributes, ParsingMode parsingMode) throws PlaylistParserException {
        SegmentMap.Builder builder = SegmentMap.builder();
        ParserUtils.readAttributes(attributeMap, attributes, builder, parsingMode);
        return builder.build();
    }

    static {
        attributeMap = ParserUtils.toMap(SegmentMapAttribute.values(), Attribute::key);
    }
}

