/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.http4k.core.UriKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003J\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00102\u0006\u0010\u000e\u001a\u00020\u0003J\u001a\u0010\u0011\u001a\u00020\u00032\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0010J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0003J\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\f*\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J<\u0010\u0016\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00072\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00030\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u0003H\u0016J\t\u0010\u001c\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\r2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/http4k/core/UriTemplate;", "", "template", "", "<init>", "(Ljava/lang/String;)V", "templateRegex", "Lkotlin/text/Regex;", "matches", "Lkotlin/sequences/Sequence;", "Lkotlin/text/MatchResult;", "parameterNames", "", "", "uri", "extract", "", "generate", "parameters", "prefixed", "prefix", "findParameterValues", "replace", "regex", "notMatched", "Lkotlin/Function1;", "matched", "toString", "component1", "copy", "equals", "other", "hashCode", "", "Companion", "http4k-core"})
@SourceDebugExtension(value={"SMAP\nUriTemplate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UriTemplate.kt\norg/http4k/core/UriTemplate\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1563#2:60\n1634#2,3:61\n*S KotlinDebug\n*F\n+ 1 UriTemplate.kt\norg/http4k/core/UriTemplate\n*L\n40#1:60\n40#1:61,3\n*E\n"})
public final class UriTemplate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String template;
    @NotNull
    private final Regex templateRegex;
    @NotNull
    private final Sequence<MatchResult> matches;
    @NotNull
    private final List<String> parameterNames;
    @NotNull
    private static final Regex URI_TEMPLATE_FORMAT = new Regex("\\{([^}]+?)(?::([^}]+))?\\}");

    private UriTemplate(String template) {
        this.template = template;
        this.templateRegex = new Regex(this.replace(this.template, URI_TEMPLATE_FORMAT, (Function1<? super String, String>)((Function1)UriTemplate::templateRegex$lambda$0), (Function1<? super MatchResult, String>)((Function1)UriTemplate::templateRegex$lambda$1)));
        this.matches = Regex.findAll$default((Regex)URI_TEMPLATE_FORMAT, (CharSequence)this.template, (int)0, (int)2, null);
        this.parameterNames = SequencesKt.toList((Sequence)SequencesKt.map(this.matches, UriTemplate::parameterNames$lambda$2));
    }

    public final boolean matches(@NotNull String uri2) {
        Intrinsics.checkNotNullParameter((Object)uri2, (String)"uri");
        return this.templateRegex.matches((CharSequence)UriTemplate.Companion.trimSlashes(uri2));
    }

    @NotNull
    public final Map<String, String> extract(@NotNull String uri2) {
        Intrinsics.checkNotNullParameter((Object)uri2, (String)"uri");
        return MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)this.parameterNames, (Iterable)this.findParameterValues(this.templateRegex, UriTemplate.Companion.trimSlashes(uri2))));
    }

    @NotNull
    public final String generate(@NotNull Map<String, String> parameters) {
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        CharSequence charSequence = this.template;
        Regex regex = URI_TEMPLATE_FORMAT;
        Function1 function1 = arg_0 -> UriTemplate.generate$lambda$3(parameters, arg_0);
        return regex.replace(charSequence, function1);
    }

    @NotNull
    public final UriTemplate prefixed(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return Companion.from(prefix + "/" + this.template);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> findParameterValues(Regex $this$findParameterValues, String uri2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.drop((Iterable)((MatchResult)SequencesKt.first((Sequence)Regex.findAll$default((Regex)$this$findParameterValues, (CharSequence)uri2, (int)0, (int)2, null))).getGroupValues(), (int)1);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UriKt.toPathSegmentDecoded((String)it));
        }
        return (List)destination$iv$iv;
    }

    private final String replace(String $this$replace, Regex regex, Function1<? super String, String> notMatched, Function1<? super MatchResult, String> matched) {
        Sequence matches = Regex.findAll$default((Regex)regex, (CharSequence)$this$replace, (int)0, (int)2, null);
        StringBuilder builder = new StringBuilder();
        int position = 0;
        for (MatchResult matchResult : matches) {
            String before;
            Intrinsics.checkNotNullExpressionValue((Object)$this$replace.substring(position, matchResult.getRange().getFirst()), (String)"substring(...)");
            if (((CharSequence)before).length() > 0) {
                builder.append((String)notMatched.invoke((Object)before));
            }
            builder.append((String)matched.invoke((Object)matchResult));
            position = matchResult.getRange().getLast() + 1;
        }
        String string = $this$replace.substring(position, $this$replace.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String after = string;
        if (((CharSequence)after).length() > 0) {
            builder.append((String)notMatched.invoke((Object)after));
        }
        String string2 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    public String toString() {
        return this.template;
    }

    private final String component1() {
        return this.template;
    }

    @NotNull
    public final UriTemplate copy(@NotNull String template) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        return new UriTemplate(template);
    }

    public static /* synthetic */ UriTemplate copy$default(UriTemplate uriTemplate, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = uriTemplate.template;
        }
        return uriTemplate.copy(string);
    }

    public int hashCode() {
        return this.template.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UriTemplate)) {
            return false;
        }
        UriTemplate uriTemplate = (UriTemplate)other;
        return Intrinsics.areEqual((Object)this.template, (Object)uriTemplate.template);
    }

    private static final String templateRegex$lambda$0(String notMatched) {
        Intrinsics.checkNotNullParameter((Object)notMatched, (String)"notMatched");
        String string = Pattern.quote(notMatched);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"quote(...)");
        return string;
    }

    private static final String templateRegex$lambda$1(MatchResult matched) {
        Intrinsics.checkNotNullParameter((Object)matched, (String)"matched");
        return StringsKt.isBlank((CharSequence)((CharSequence)matched.getGroupValues().get(2))) ? "([^/]+)" : "(" + matched.getGroupValues().get(2) + ")";
    }

    private static final String parameterNames$lambda$2(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (String)it.getGroupValues().get(1);
    }

    private static final CharSequence generate$lambda$3(Map $parameters, MatchResult matchResult) {
        String paramValue;
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        String string = (String)$parameters.get(matchResult.getGroupValues().get(1));
        if (string == null) {
            string = "";
        }
        return StringsKt.contains$default((CharSequence)(paramValue = string), (CharSequence)"/", (boolean)false, (int)2, null) ? (CharSequence)paramValue : (CharSequence)UriKt.toPathSegmentEncoded(paramValue);
    }

    public /* synthetic */ UriTemplate(String template, DefaultConstructorMarker $constructor_marker) {
        this(template);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\f\u0010\n\u001a\u00020\t*\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/http4k/core/UriTemplate$Companion;", "", "<init>", "()V", "URI_TEMPLATE_FORMAT", "Lkotlin/text/Regex;", "from", "Lorg/http4k/core/UriTemplate;", "template", "", "trimSlashes", "http4k-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UriTemplate from(@NotNull String template) {
            Intrinsics.checkNotNullParameter((Object)template, (String)"template");
            return new UriTemplate(this.trimSlashes(template), null);
        }

        private final String trimSlashes(String $this$trimSlashes) {
            return new Regex("^(/+)?(.*?)(/+)?$").replace((CharSequence)$this$trimSlashes, Companion::trimSlashes$lambda$0);
        }

        private static final CharSequence trimSlashes$lambda$0(MatchResult result) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            return (CharSequence)result.getGroupValues().get(2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

