/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.filter;

import java.time.Clock;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.core.Filter;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.filter.DefaultCacheTimings;
import org.http4k.filter.MaxAgeTtl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0006"}, d2={"Lorg/http4k/filter/CachingFilters;", "", "<init>", "()V", "CacheRequest", "CacheResponse", "http4k-core"})
public final class CachingFilters {
    @NotNull
    public static final CachingFilters INSTANCE = new CachingFilters();

    private CachingFilters() {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/http4k/filter/CachingFilters$CacheRequest;", "", "<init>", "()V", "AddIfModifiedSince", "Lorg/http4k/core/Filter;", "clock", "Ljava/time/Clock;", "maxAge", "Ljava/time/Duration;", "http4k-core"})
    public static final class CacheRequest {
        @NotNull
        public static final CacheRequest INSTANCE = new CacheRequest();

        private CacheRequest() {
        }

        @NotNull
        public final Filter AddIfModifiedSince(@NotNull Clock clock, @NotNull Duration maxAge) {
            Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
            Intrinsics.checkNotNullParameter((Object)maxAge, (String)"maxAge");
            return arg_0 -> CacheRequest.AddIfModifiedSince$lambda$1(clock, maxAge, arg_0);
        }

        private static final Response AddIfModifiedSince$lambda$1$lambda$0(Function1 $next, Clock $clock, Duration $maxAge, Request it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (Response)$next.invoke((Object)it.replaceHeader("If-Modified-Since", DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now($clock).minus($maxAge))));
        }

        private static final Function1 AddIfModifiedSince$lambda$1(Clock $clock, Duration $maxAge, Function1 next) {
            Intrinsics.checkNotNullParameter((Object)next, (String)"next");
            return arg_0 -> CacheRequest.AddIfModifiedSince$lambda$1$lambda$0(next, $clock, $maxAge, arg_0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u0004\u0005\u0006\u0007B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\b"}, d2={"Lorg/http4k/filter/CachingFilters$CacheResponse;", "", "<init>", "()V", "CacheFilter", "NoCache", "MaxAge", "FallbackCacheControl", "http4k-core"})
    public static final class CacheResponse {
        @NotNull
        public static final CacheResponse INSTANCE = new CacheResponse();

        private CacheResponse() {
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\"\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J,\u0010\b\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nj\u0002`\f0\tj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u0004H&JO\u0010\u000f\u001a!\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u00142%\u0010\u0015\u001a!\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0014H\u0096\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/http4k/filter/CachingFilters$CacheResponse$CacheFilter;", "Lorg/http4k/core/Filter;", "predicate", "Lkotlin/Function1;", "Lorg/http4k/core/Response;", "", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "headersFor", "", "Lkotlin/Pair;", "", "Lorg/http4k/core/Parameter;", "Lorg/http4k/core/Headers;", "response", "invoke", "Lorg/http4k/core/Request;", "Lkotlin/ParameterName;", "name", "request", "Lorg/http4k/core/HttpHandler;", "next", "http4k-core"})
        @SourceDebugExtension(value={"SMAP\nCachingFilters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachingFilters.kt\norg/http4k/filter/CachingFilters$CacheResponse$CacheFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1803#2,3:133\n*S KotlinDebug\n*F\n+ 1 CachingFilters.kt\norg/http4k/filter/CachingFilters$CacheResponse$CacheFilter\n*L\n69#1:133,3\n*E\n"})
        private static abstract class CacheFilter
        implements Filter {
            @NotNull
            private final Function1<Response, Boolean> predicate;

            public CacheFilter(@NotNull Function1<? super Response, Boolean> predicate) {
                Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
                this.predicate = predicate;
            }

            @NotNull
            public abstract List<Pair<String, String>> headersFor(@NotNull Response var1);

            @NotNull
            public Function1<Request, Response> invoke(@NotNull Function1<? super Request, ? extends Response> next) {
                Intrinsics.checkNotNullParameter(next, (String)"next");
                return arg_0 -> CacheFilter.invoke$lambda$1(next, this, arg_0);
            }

            /*
             * WARNING - void declaration
             */
            private static final Response invoke$lambda$1(Function1 $next, CacheFilter this$0, Request it) {
                void $this$fold$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Response response = (Response)$next.invoke((Object)it);
                List<Pair<String, String>> headers = it.getMethod() == Method.GET && (Boolean)this$0.predicate.invoke((Object)response) != false ? this$0.headersFor(response) : CollectionsKt.emptyList();
                Iterable iterable = headers;
                Response initial$iv = response;
                boolean $i$f$fold = false;
                Response accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    Pair pair = (Pair)element$iv;
                    Response memo = accumulator$iv;
                    boolean bl = false;
                    String first = (String)pair.component1();
                    String second = (String)pair.component2();
                    accumulator$iv = memo.replaceHeader(first, second);
                }
                return accumulator$iv;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0086\u0002\u00a8\u0006\f"}, d2={"Lorg/http4k/filter/CachingFilters$CacheResponse$FallbackCacheControl;", "", "<init>", "()V", "invoke", "Lorg/http4k/core/Filter;", "defaultCacheTimings", "Lorg/http4k/filter/DefaultCacheTimings;", "predicate", "Lkotlin/Function1;", "Lorg/http4k/core/Response;", "", "http4k-core"})
        @SourceDebugExtension(value={"SMAP\nCachingFilters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachingFilters.kt\norg/http4k/filter/CachingFilters$CacheResponse$FallbackCacheControl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n774#2:133\n865#2,2:134\n1#3:136\n*S KotlinDebug\n*F\n+ 1 CachingFilters.kt\norg/http4k/filter/CachingFilters$CacheResponse$FallbackCacheControl\n*L\n118#1:133\n118#1:134,2\n*E\n"})
        public static final class FallbackCacheControl {
            @NotNull
            public static final FallbackCacheControl INSTANCE = new FallbackCacheControl();

            private FallbackCacheControl() {
            }

            @NotNull
            public final Filter invoke(@NotNull DefaultCacheTimings defaultCacheTimings, @NotNull Function1<? super Response, Boolean> predicate) {
                Intrinsics.checkNotNullParameter((Object)defaultCacheTimings, (String)"defaultCacheTimings");
                Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
                return arg_0 -> FallbackCacheControl.invoke$lambda$6(predicate, defaultCacheTimings, arg_0);
            }

            public static /* synthetic */ Filter invoke$default(FallbackCacheControl fallbackCacheControl, DefaultCacheTimings defaultCacheTimings, Function1 function1, int n, Object object) {
                if ((n & 2) != 0) {
                    function1 = FallbackCacheControl::invoke$lambda$0;
                }
                return fallbackCacheControl.invoke(defaultCacheTimings, (Function1<? super Response, Boolean>)function1);
            }

            private static final boolean invoke$lambda$0(Response it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getStatus().getCode() < 400;
            }

            private static final Response invoke$addDefaultHeaderIfAbsent(Response response, String header, Function0<String> defaultProducer) {
                String string = response.header(header);
                if (string == null) {
                    string = (String)defaultProducer.invoke();
                }
                return response.replaceHeader(header, string);
            }

            /*
             * WARNING - void declaration
             */
            private static final String invoke$addDefaultCacheHeadersIfAbsent$lambda$2(DefaultCacheTimings $defaultCacheTimings) {
                void $this$filterTo$iv$iv;
                Object[] objectArray = new String[]{"public", $defaultCacheTimings.getMaxAge().toHeaderValue(), $defaultCacheTimings.getStaleWhenRevalidateTtl().toHeaderValue(), $defaultCacheTimings.getStaleIfErrorTtl().toHeaderValue()};
                Iterable $this$filter$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)""))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            }

            private static final String invoke$addDefaultCacheHeadersIfAbsent$lambda$4$lambda$3() {
                return "Accept-Encoding";
            }

            private static final Response invoke$addDefaultCacheHeadersIfAbsent(DefaultCacheTimings $defaultCacheTimings, Response response) {
                Response it = FallbackCacheControl.invoke$addDefaultHeaderIfAbsent(response, "Cache-Control", (Function0<String>)((Function0)() -> FallbackCacheControl.invoke$addDefaultCacheHeadersIfAbsent$lambda$2($defaultCacheTimings)));
                boolean bl = false;
                return FallbackCacheControl.invoke$addDefaultHeaderIfAbsent(it, "Vary", (Function0<String>)((Function0)FallbackCacheControl::invoke$addDefaultCacheHeadersIfAbsent$lambda$4$lambda$3));
            }

            private static final Response invoke$lambda$6$lambda$5(Function1 $next, Function1 $predicate, DefaultCacheTimings $defaultCacheTimings, Request it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Response response = (Response)$next.invoke((Object)it);
                return it.getMethod() == Method.GET && (Boolean)$predicate.invoke((Object)response) != false ? FallbackCacheControl.invoke$addDefaultCacheHeadersIfAbsent($defaultCacheTimings, response) : response;
            }

            private static final Function1 invoke$lambda$6(Function1 $predicate, DefaultCacheTimings $defaultCacheTimings, Function1 next) {
                Intrinsics.checkNotNullParameter((Object)next, (String)"next");
                return arg_0 -> FallbackCacheControl.invoke$lambda$6$lambda$5(next, $predicate, $defaultCacheTimings, arg_0);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0086\u0002\u00a8\u0006\f"}, d2={"Lorg/http4k/filter/CachingFilters$CacheResponse$MaxAge;", "", "<init>", "()V", "invoke", "Lorg/http4k/core/Filter;", "maxAge", "Ljava/time/Duration;", "predicate", "Lkotlin/Function1;", "Lorg/http4k/core/Response;", "", "http4k-core"})
        public static final class MaxAge {
            @NotNull
            public static final MaxAge INSTANCE = new MaxAge();

            private MaxAge() {
            }

            @NotNull
            public final Filter invoke(@NotNull Duration maxAge, @NotNull Function1<? super Response, Boolean> predicate) {
                Intrinsics.checkNotNullParameter((Object)maxAge, (String)"maxAge");
                Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
                return new CacheFilter(predicate, maxAge){
                    final /* synthetic */ Duration $maxAge;
                    {
                        this.$maxAge = $maxAge;
                        super($predicate);
                    }

                    public List<Pair<String, String>> headersFor(Response response) {
                        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                        Object[] objectArray = new String[]{"public", new MaxAgeTtl(this.$maxAge).toHeaderValue()};
                        return CollectionsKt.listOf((Object)TuplesKt.to((Object)"Cache-Control", (Object)CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)));
                    }
                };
            }

            public static /* synthetic */ Filter invoke$default(MaxAge maxAge, Duration duration2, Function1 function1, int n, Object object) {
                if ((n & 2) != 0) {
                    function1 = MaxAge::invoke$lambda$0;
                }
                return maxAge.invoke(duration2, (Function1<? super Response, Boolean>)function1);
            }

            private static final boolean invoke$lambda$0(Response it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getStatus().getCode() < 400;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0086\u0002\u00a8\u0006\n"}, d2={"Lorg/http4k/filter/CachingFilters$CacheResponse$NoCache;", "", "<init>", "()V", "invoke", "Lorg/http4k/core/Filter;", "predicate", "Lkotlin/Function1;", "Lorg/http4k/core/Response;", "", "http4k-core"})
        public static final class NoCache {
            @NotNull
            public static final NoCache INSTANCE = new NoCache();

            private NoCache() {
            }

            @NotNull
            public final Filter invoke(@NotNull Function1<? super Response, Boolean> predicate) {
                Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
                return new CacheFilter(predicate){

                    public List<Pair<String, String>> headersFor(Response response) {
                        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                        return CollectionsKt.listOf((Object)TuplesKt.to((Object)"Cache-Control", (Object)"private, must-revalidate"));
                    }
                };
            }

            public static /* synthetic */ Filter invoke$default(NoCache noCache, Function1 function1, int n, Object object) {
                if ((n & 1) != 0) {
                    function1 = NoCache::invoke$lambda$0;
                }
                return noCache.invoke((Function1<? super Response, Boolean>)function1);
            }

            private static final boolean invoke$lambda$0(Response it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getStatus().getCode() < 400;
            }
        }
    }
}

